<?php
$dvartypes = array(0 => "UINT16", 1 => "INT16", 2 => "UINT32", 3 => "INT32", 4 => "REAL", 5 => "STRING", 6 => "UINT64", 7 => "INT64");
$dswapmodes = array(0 => "N/A", 1 => "Byte and Word Swap", 2 => "Byte Swap", 3 => "Word Swap", 4 => "64 Bit Reverse");


class MyDB extends SQLite3
{
   function __construct()
   {
      $this->open('/kirac/db/sungateway.db');
   }
}

$db = new MyDB();
if (!$db) {
   echo $db->lastErrorMsg();
}

$mbusdevice_kno = $_GET['frecordno'];

$sql = <<<EOF
   SELECT kno,device_id,station_id,comm_type,device_name from tblmbusdevices where kno=$mbusdevice_kno;
EOF;

$ret = $db->query($sql);
$row = $ret->fetchArray(SQLITE3_ASSOC);
$mbusdevice_id = $row['device_id'];
$mbusdevice_name = $row['device_name'];
$mbusdevice_station_id = $row['station_id'];
$mbusdevice_comm_type = $row['comm_type'];

$sql = <<<EOF
     SELECT * from tblmbusvars where dkno=$mbusdevice_kno;
EOF;

echo '<table id="tableDeviceData">
        <tr class="tableHeader">
        <th style="display:none;">Record No</th>
        <th>İstasyon ID</th>
        <th>Slave ID</th>
        <th>Device ID</th>
        <th>Register Adresi</th>
        <th>Modbus/Kaco Fonk</th>
        <th>Swap Modu</th>
        <th>Register Tipi</th>
        <th>Register Çarpanı</th>
        <th>Register Tanımı</th>
        </tr>';

$ret = $db->query($sql);
while ($row = $ret->fetchArray(SQLITE3_ASSOC)) {
   echo '<tr class="tableData" onclick="tableRowClick(this,2)" ondblclick="cihazDataEkle(1)">';
   echo '<td id="colRecordNo" style="display:none;">' . $row['kno'] . '</td>';
   echo '<td id="colSID">' . $mbusdevice_station_id . '</td>';
   echo '<td id="colID">' . $mbusdevice_id . '</td>';
   echo '<td id="colNAME">' . $mbusdevice_name . '</td>';
   echo '<td id="colRegAddress">' . $row['reg_addr'] . '</td>';
   if ($mbusdevice_comm_type < 2) {
      echo '<td id="colMBusFunction">' . $row['mbus_function'] . '</td>';
   } else {
      echo '<td id="colMBusFunction">' . chr($row['mbus_function']) . '</td>';
   }
   echo '<td id="colSwapMode">' . $dswapmodes[$row['swap_mode']] . '</td>';
   echo '<td id="colRegVarType">' . $dvartypes[$row['reg_var_type']] . '</td>';
   echo '<td id="colMultiplier">' . $row['reg_multiplier'] . '</td>';
   echo '<td id="colDefinition">' . $row['reg_def'] . '</td>';
   echo '</tr>';
}

echo '</table>';

$db->close();
?>
