<?php
ob_start();
session_start();
?>

<?php
if (isset($_SESSION['LAST_ACTIVITY']) && (time() - $_SESSION['LAST_ACTIVITY'] > 1800)) {
  session_unset();
  session_destroy();
}
$_SESSION['LAST_ACTIVITY'] = time();
if (!isset($_SESSION['login_ok'])) {
  include("login.php");
  exit();
}
  function debug_to_console($data) {
    $output = $data;
    if (is_array($output))
        $output = implode(',', $output);

    echo "<script>console.log('Debug Objects: " . $output . "' );</script>";
  }

?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <title>MPDL</title>
  <script src="jquery.min.js"></script>
</head>

<style>
  * {
    margin: 0;
    padding: 0;
  }

  html {
    min-height: 100%;
    position: relative;
  }

  body {
    height: 100%;
    font-family: sans-serif;
  }

  .wrapper {
    position: absolute;
    top: 0;
    bottom: 0;
    left: 0;
    right: 0;
    overflow: hidden;
    display: grid;
    grid-template-columns: 1fr 6fr;
    grid-template-rows: 60px auto 50px;
    grid-gap: 3px;
  }

  .header {
    grid-column: 1/3;
    color: white;
    background-color: #5C6BC0;
  }

  .footer {
    grid-column: 1/3;
    color: white;
    background-color: #5C6BC0;
  }

  .left-side {
    background-color: #323232;
    overflow-y: auto;
    min-width: 150px;
  }

  .right-side {
    background-color: white;
    overflow-y: auto;
  }

  .left-side li a {
    display: block;
    color: #eee;
    background-color: #424242;
    padding: 10px;
    text-decoration: none;
    text-align: left;
    border-bottom: 1px solid;
    font-size: 18px;
  }

  .header h2 {
    text-align: center;
    padding: 20px;
  }

  .footer p {
    text-align: center;
    padding: 20px;
  }

  .port-config form {
    background: -webkit-linear-gradient(bottom, #CCCCCC, #EEEEEE 175px);
    background: -moz-linear-gradient(bottom, #CCCCCC, #EEEEEE 175px);
    background: linear-gradient(bottom, #CCCCCC, #EEEEEE 175px);
    margin: auto;
    position: relative;
    line-height: 24px;
    font-weight: bold;
    color: #09C;
    text-decoration: none;
    border-radius: 10px;
    padding: 10px;
    border: 1px solid #999;
    border: inset 1px solid #333;
    -webkit-box-shadow: 0 0 8px rgba(0, 0, 0, 0.3);
    -moz-box-shadow: 0 0 8px rgba(0, 0, 0, 0.3);
    box-shadow: 0 0 8px rgba(0, 0, 0, 0.3);
  }

  .port-config input,
  .port-config select {
    width: 100%;
    display: block;
    border: 1px solid #999;
    height: 25px;
    -webkit-box-shadow: 0 0 8px rgba(0, 0, 0, 0.3);
    -moz-box-shadow: 0 0 8px rgba(0, 0, 0, 0.3);
    box-shadow: 0 0 8px rgba(0, 0, 0, 0.3);
  }

  .input-row {
    margin-bottom: 10px;
  }

  .w3-check,
  .w3-radio {
    width: 24px;
    height: 24px;
    position: relative;
    top: 6px;
  }

  #div-user-settings,
  #div-upload-packet,
  #div-download-file,
  #div-confimport,
  #div-confexport,
  #div-device-definition,
  #div-ip-configuration,
  #div-device-status,
  #div-modbus-configuration,
  #div-restart,
  #div-stop-program,
  #div-start-program {
    display: none;
  }

  .btn-group button {
    background-color: #555;
    /* Green background */
    border: 1px solid #aaa;
    /* Green border */
    color: white;
    /* White text */
    padding: 10px 24px;
    /* Some padding */
    cursor: pointer;
    /* Pointer/hand icon */
    float: left;
    /* Float the buttons side by side */
  }

  /* Clear floats (clearfix hack) */

  .btn-group:after {
    content: "";
    clear: both;
    display: table;
  }

  .btn-group button:not(:last-child) {
    border-right: none;
    /* Prevent double borders */
  }

  /* Add a background color on hover */

  .btn-group button:hover {
    background-color: #777;
  }

  .col-25 {
    float: left;
    width: 25%;
    margin-top: 6px;
  }

  .col-75 {
    float: left;
    width: 75%;
    margin-top: 6px;
  }

  .col-30 {
    float: left;
    width: 30%;
    margin-top: 6px;
  }

  .col-70 {
    float: left;
    width: 70%;
    margin-top: 6px;
  }

  .row:after {
    content: "";
    display: table;
    clear: both;
  }

  input[type=text],
  input[type=password],
  select {
    width: 100%;
    padding: 12px;
    border: 1px solid #ccc;
    border-radius: 4px;
    /*resize: vertical;*/
    box-sizing: border-box;
    -moz-box-sizing: border-box;
    -webkit-box-sizing: border-box;
  }

  input[type=checkbox] {
    /* width: 100%; */
    padding: 12px;
    margin-top: 15px;
    border: 1px solid #ccc;
    border-radius: 4px;
    /*resize: vertical;*/
    box-sizing: border-box;
    -moz-box-sizing: border-box;
    -webkit-box-sizing: border-box;
  }

  label {
    padding: 12px 12px 12px 0;
    display: inline-block;
  }

  input[type=submit] {
    background-color: #555;
    color: white;
    padding: 12px 20px;
    border: none;
    border-radius: 4px;
    cursor: pointer;
    /*float: right;*/
  }

  input[type=submit]:hover {
    background-color: #777;
  }


  .inputfile {
	/*width: 0.1px;
	height: 0.1px;
	opacity: 0;
	overflow: hidden; */
	position: absolute;
	z-index: -1;
  }

  .inputfile + label {
    font-size: 13px;
    background-color: #555;
    /* Green background */
    border: 1px solid #aaa;
    /* Green border */
    color: white;
    /* White text */
    padding: 10px 24px;
    /* Some padding */
    cursor: pointer;

    display: inline-block;

  }

  .inputfile:focus + label,
  .inputfile + label:hover {
    background-color: #777;
  }


  table {
    border-collapse: collapse;
    width: 100%;
  }

  td,
  th {
    padding: 8px;
    text-align: left;
    border-bottom: 1px solid #ddd;
  }

  .selected {
    background-color: #5C6BC0;
    color: #FFF;
  }

  .modal {
    display: none;
    /* Hidden by default */
    position: fixed;
    /* Stay in place */
    z-index: 1;
    /* Sit on top */
    padding-top: 50px;
    /* Sit on top */
    padding-bottom: 200px;

    /* Location of the box */
    left: 0;
    top: 0;
    width: 100%;
    /* Full width */
    height: 100%;
    /* Full height */
    overflow: auto;
    /* Enable scroll if needed */
    background-color: rgb(0, 0, 0);
    /* Fallback color */
    background-color: rgba(0, 0, 0, 0.4);
    /* Black w/ opacity */
  }

  /* Modal Content */

  .modal-content {
    background-color: #fefefe;
    margin: auto;
    padding: 20px;
    border: 1px solid #888;
    width: 50%;
    overflow: auto;
  }

  /* The Close Button */

  .close {
    color: #aaaaaa;
    float: right;
    font-size: 28px;
    font-weight: bold;
  }

  .close:focus,
  .close:hover {
    color: #000;
    text-decoration: none;
    cursor: pointer;
  }

  /* Change styles for small screens */
  @media screen and (max-width: 600px) {
    .modal-content {
      background-color: #fefefe;
      margin: auto;
      padding: 5px;
      border: 1px solid #888;
      width: 90%;
      overflow: auto;
    }

    .btn-group button {
      background-color: #555;
      /* Green background */
      border: 1px solid #aaa;
      /* Green border */
      color: white;
      /* White text */
      padding: 2px 6px;
      /* Some padding */
      cursor: pointer;
      /* Pointer/hand icon */
      float: left;
      /* Float the buttons side by side */
    }

    .col-25 {
      float: left;
      width: 40%;
      margin-top: 6px;
    }

    .col-75 {
      float: left;
      width: 60%;
      margin-top: 6px;
    }
  }
</style>

<script>
  function myFunction() {
    alert("The form was submitted");
  }

  function HTTP_get(cgi_dosyasi, field, field_val, html_content) {
    var xmlhttp = new XMLHttpRequest();
    xmlhttp.onreadystatechange = function() {
      if (this.readyState == 4 && this.status == 200) {
        if (html_content!=null) document.getElementById(html_content).innerHTML = this.responseText;
      }
    };
    var req = cgi_dosyasi;

    oldCgiDosyasi = cgi_dosyasi;

    if (field != "") {
      req += "?" + field + "=" + field_val;
    }
    xmlhttp.open("GET", req, true);
    xmlhttp.send();
  }

  function SideBarClick(SenderID, SetToVisibleDivId) {

    document.getElementById(OldVisibleRightSideDiv).style.display = "none";

    if (OldHighlightedSideMenuID != "") {
      document.getElementById(OldHighlightedSideMenuID).style.backgroundColor = "#424242";
    }

    document.getElementById(SetToVisibleDivId).style.display = "block";
    document.getElementById(SenderID).style.backgroundColor = "#5C6BC0";
    OldVisibleRightSideDiv = SetToVisibleDivId;
    OldHighlightedSideMenuID = SenderID;


    if (SenderID == "liIPConfig") {
      HTTP_get("table_ip_ayarlari.php", "", 0, "table_content_ip_ayarlari");
    }

    if (SenderID == "liMODBusConfig") {
      HTTP_get("table_rs_ayarlari.php", "", 0, "table_content_rs_ayarlari");
    }

    if (SenderID == "liDeviceDefinition") {
      document.getElementById("table_content_cihaz_listesi").innerHTML = "";
      document.getElementById("table_content_cihaz_datasi").innerHTML = "";
      tableDeviceListSelectedRow = 0;
      tableDeviceDataSelectedRow = 0;
      HTTP_get("table_cihaz_listesi.php", "", 0, "table_content_cihaz_listesi");
    }

    if (SenderID == "liRestart") {
      document.getElementById("content_restart").innerHTML = "";
    }

    if (SenderID == "liStopProgram") {
      document.getElementById("content_stop_program").innerHTML = "";
    }

    if (SenderID == "liStartProgram") {
      document.getElementById("content_start_program").innerHTML = "";
    }

    if (SenderID == "liUserSettings") {
      HTTP_get("table_kullanici_ayarlari.php", "", 0, "table_content_kullanici_ayarlari");
    }

  }

  function postform(url, form, callback) {
    $.post(url, $(form).serialize(), function(data, status) {
      if (callback != 0)
        callback(data, status);
    }, 'text');
  }

  function postform_upload(url,formname) {

    //"#formUploadPacket"
    var form = $(formname).closest("form");
    var formData = new FormData(form[0]);

    $.ajax({
      url: url,
      method: "post",
      processData: false,
      contentType: false,
      data: formData,
      success: function(data) {
        alert(data);
      },
      error: "callback(data,false)"
    });
  }


  function tableRowClick(owner, sender) {
    $(owner).addClass('selected').siblings().removeClass('selected');

    if (sender == 1) {
      if (owner == tableDeviceListSelectedRow)
        return;
      tableDeviceListSelectedRow = owner;
      tableDeviceDataSelectedRow = 0;

      device_record_no = $(tableDeviceListSelectedRow).find('td#colRecordNo').html();
      getTableData("table_cihaz_datasi.php", "table_content_cihaz_datasi", device_record_no);
    } else if (sender == 2) {
      if (owner == tableDeviceDataSelectedRow)
        return;
      tableDeviceDataSelectedRow = owner;
    }
  }

  function rowSelectTableDeviceList(record_no) {
    var table = document.getElementById('tableDeviceList');
    var rowLength = table.rows.length;
    var owner;
    if (rowLength < 2)
      return;

    for (var i = 1; i < rowLength; i += 1) {
      var row = table.rows[i];
      var cell = row.cells[0];

      if ($(cell).html() == record_no) {
        owner = row;
        break;
      }
    }

    if (!owner)
      return;
    $(owner).addClass('selected').siblings().removeClass('selected');
    tableDeviceListSelectedRow = owner;
    device_record_no = $(tableDeviceListSelectedRow).find('td#colRecordNo').html();
    getTableData("table_cihaz_datasi.php", "table_content_cihaz_datasi", device_record_no);
  }

  function rowSelectTableDeviceData(record_no) {
    var table = document.getElementById('tableDeviceData');
    var rowLength = table.rows.length;
    var owner;
    if (rowLength < 2)
      return;

    for (var i = 1; i < rowLength; i += 1) {
      var row = table.rows[i];
      var cell = row.cells[0];

      if ($(cell).html() == record_no) {
        owner = row;
        break;
      }
    }

    if (!owner)
      return;
    $(owner).addClass('selected').siblings().removeClass('selected');
    tableDeviceDataSelectedRow = owner;
  }

  function getTableData(cgi_dosyasi, html_content, record_no) {
    var xmlhttp = new XMLHttpRequest();

    xmlhttp.onreadystatechange = function() {
      if (this.readyState == 4 && this.status == 200) {
        if (this.responseText == "") {
          window.location.href = "/embeded.html";
        } else {
          document.getElementById(html_content).innerHTML = this.responseText;

          if (record_no == -1) {
            if (tableDeviceListSelectedRow)
              rowSelectTableDeviceList($(tableDeviceListSelectedRow).find('td#colRecordNo').html());
          } else {
            if (tableDeviceDataSelectedRow)
              rowSelectTableDeviceData($(tableDeviceDataSelectedRow).find('td#colRecordNo').html());
          }
        }
      } else if (this.readyState == 4 && this.status == 404) {}
    };

    var req = cgi_dosyasi;

    if (record_no != -1) {
      req += "?frecordno=" + record_no;
    }

    xmlhttp.open("GET", req, true);
    xmlhttp.send();
  }

  function TableCihazEkleResultCallback(data, status) {
    getTableData("table_cihaz_listesi.php", "table_content_cihaz_listesi", -1);
    tableDeviceListSelectedRow = 0;
    tableDeviceDataSelectedRow = 0;
    getTableData("table_cihaz_datasi.php", "table_content_cihaz_datasi", 0);
    modalDeviceTableChange.style.display = "none";
  }

  function TableCihazKopyalaResultCallback(data, status) {
    getTableData("table_cihaz_listesi.php", "table_content_cihaz_listesi", -1);
    tableDeviceListSelectedRow = 0;
    tableDeviceDataSelectedRow = 0;
    getTableData("table_cihaz_datasi.php", "table_content_cihaz_datasi", 0);
    modalDeviceTableCopy.style.display = "none";
  }

  function TableCihazDegistirResultCallback(data, status) {
    getTableData("table_cihaz_listesi.php", "table_content_cihaz_listesi", -1);
    modalDeviceTableChange.style.display = "none";
  }

  function TableKullaniciayarlariResultCallback(data, status) {
    $("#formKullaniciAyarlari input[name='foldpass']").val("");
    $("#formKullaniciAyarlari input[name='fnewpass']").val("");
    $("#formKullaniciAyarlari input[name='fnewpassagain']").val("");
    alert(data);
  }

  function TableCihazSilResultCallback(data, status) {
    TableCihazEkleResultCallback(data, status);
  }

  function TableCihazDataEkleResultCallback(data, status) {
    device_record_no = $(tableDeviceListSelectedRow).find('td#colRecordNo').html();
    getTableData("table_cihaz_datasi.php", "table_content_cihaz_datasi", device_record_no);
    tableDeviceDataSelectedRow = 0;
    modalDeviceDataTableChange.style.display = "none";
  }

  function TableCihazDataDegistirResultCallback(data, status) {
    device_record_no = $(tableDeviceListSelectedRow).find('td#colRecordNo').html();
    getTableData("table_cihaz_datasi.php", "table_content_cihaz_datasi", device_record_no);
    modalDeviceDataTableChange.style.display = "none";
  }

  function TableCihazDataTestResultCallback(data, status) {
    alert(data);
  }

  function TableCihazDataSilResultCallback(data, status) {
    TableCihazDataEkleResultCallback(data, status);
  }

  function cihazEkle(ekleDegistirSil) {

    if (ekleDegistirSil != 0) {
      if (tableDeviceListSelectedRow == 0)
        return;
    }

    var submitButton = $("#formModbusCihazEkle button");

    var recordActionType = $("#formModbusCihazEkle input[name='frecordactiontype']");
    var recordNo = $("#formModbusCihazEkle input[name='frecordno']");
    var selectCommType = $("#formModbusCihazEkle select[name='fcommtype']");
    var selectCommTypeSelectedItems = $(':selected', '#selectCommType');
    var selectSwapMode = $("#formModbusCihazEkle select[name='fswapmode']");
    var selectSwapModeSelectedItems = $(':selected', '#selectSwapMode');
    var inputDeviceID = $("#formModbusCihazEkle input[name='fdeviceid']");
	var inputDeviceName = $("#formModbusCihazEkle input[name='fdevicename']");
    var inputDeviceIP = $("#formModbusCihazEkle input[name='fdeviceip']");
    var inputTCPPort = $("#formModbusCihazEkle input[name='ftcpport']");
    var inputDeviceDefinition = $("#formModbusCihazEkle input[name='fdevicedef']");
    var inputActive = $("#formModbusCihazEkle input[name='factive']");
    var inputDeviceSatationID = $("#formModbusCihazEkle input[name='fstationid']");

    if (ekleDegistirSil > 0) {
      commType = $(tableDeviceListSelectedRow).find('td#colCommType').html();
      selectCommTypeSelectedItems.removeAttr('selected');
      if (commType == "RS-485")
        selectCommType.val(0);
      else if (commType == "TCP/IP")
        selectCommType.val(1);
      else if (commType == "KACO Standard")
        selectCommType.val(2);
      else if (commType == "KACO Generic")
        selectCommType.val(3);

      swapMode = $(tableDeviceListSelectedRow).find('td#colSwapMode').html();
      selectSwapModeSelectedItems.removeAttr('selected');
      if (swapMode == "N/A")
        selectSwapMode.val(0);
      else if (swapMode == "Byte and Word Swap")
        selectSwapMode.val(1);
      else if (swapMode == "Byte Swap")
        selectSwapMode.val(2);
      else if (swapMode == "Word Swap")
        selectSwapMode.val(3);
      else if (swapMode == "64 Bit Reverse")
        selectSwapMode.val(4);

      activeValue = $(tableDeviceListSelectedRow).find('td#colActive').html();
      if (activeValue == 1) {
        inputActive.prop("checked", true);
        inputActive.val(1);
      } else {
        inputActive.prop("checked", false);
        inputActive.val(0);
      }

      inputDeviceID.val($(tableDeviceListSelectedRow).find('td#colID').html());
      inputDeviceName.val($(tableDeviceListSelectedRow).find('td#colNAME').html());
      inputDeviceIP.val($(tableDeviceListSelectedRow).find('td#colIP').html());
      inputTCPPort.val($(tableDeviceListSelectedRow).find('td#colTCPPort').html());
      inputDeviceDefinition.val($(tableDeviceListSelectedRow).find('td#colDefinition').html());
      inputDeviceSatationID.val($(tableDeviceListSelectedRow).find('td#colStationID').html());

      recordNo.val($(tableDeviceListSelectedRow).find('td#colRecordNo').html());

      if (ekleDegistirSil == 1) {
        submitButton.html("Uygula");
        recordActionType.val("1");

        submitButton.removeAttr('onclick');
        submitButton.attr('onClick', "postform('table_cihaz_ekle.php', 'form#formModbusCihazEkle', TableCihazDegistirResultCallback);");

      } else {
        submitButton.html("Sil");
        recordActionType.val("2");

        submitButton.removeAttr('onclick');
        submitButton.attr('onClick', "postform('table_cihaz_ekle.php', 'form#formModbusCihazEkle', TableCihazSilResultCallback);");

      }
    } else {
      selectCommTypeSelectedItems.removeAttr('selected');
      selectCommType.val(0);

      selectSwapModeSelectedItems.removeAttr('selected');
      selectSwapMode.val(2);

      $('input#inputDeviceID').val("");
	  $('input#inputDeviceName').val("");
      $('input#inputDeviceIP').val("");
      $('input#inputTCPPort').val("");
      $('input#inputDeviceDefinition').val("");
      $('input#inputDeviceSatationID').val("");
      submitButton.html("Ekle");
      recordActionType.val("0");
      recordNo.val("0");

      submitButton.removeAttr('onclick');
      submitButton.attr('onClick', "postform('table_cihaz_ekle.php', 'form#formModbusCihazEkle', TableCihazEkleResultCallback);");
    }

    modalDeviceTableChange.style.display = "block";
  }

  function cihazCopy() {

    if (tableDeviceListSelectedRow == 0)
      return;

    var submitButton = $("#formModbusCihazCopy button");

    var recordNo = $("#formModbusCihazCopy input[name='frecordno']");
    var inputDeviceSatationID = $("#formModbusCihazCopy input[name='fstationid']");
    var inputDeviceID = $("#formModbusCihazCopy input[name='fdeviceid']");
    var inputDeviceName = $("#formModbusCihazCopy input[name='fdevicename']");

    $('input#inputDeviceID').val("");
	$('input#inputDeviceName').val("");
    $('input#inputDeviceSatationID').val("");
    submitButton.html("Kopyala");
    recordNo.val($(tableDeviceListSelectedRow).find('td#colRecordNo').html());

    submitButton.removeAttr('onclick');
    submitButton.attr('onClick', "postform('table_cihaz_kopyala.php', 'form#formModbusCihazCopy', TableCihazKopyalaResultCallback);");
    modalDeviceTableCopy.style.display = "block";
  }

  function cihazDataEkle(ekleDegistirSil) {

    if (ekleDegistirSil != 0) {
      if (tableDeviceDataSelectedRow == 0)
        return;
    } else {
      if (tableDeviceListSelectedRow == 0)
        return;
    }

    var submitButton = $("#formModbusCihazDataEkle button[name='btnRecordAction']");
    var testButton = $("#formModbusCihazDataEkle button[name='btnTest']");

    var recordActionType = $("#formModbusCihazDataEkle input[name='frecordactiontype']");
    var recordNo = $("#formModbusCihazDataEkle input[name='frecordno']");
    var deviceRecordNo = $("#formModbusCihazDataEkle input[name='fdevicerecordno']");

    var selectVarType = $("#formModbusCihazDataEkle select[name='fvartype']");
    var selectVarTypeSelectedItems = $(':selected', '#selectVarType');

    var inputMBusFunction = $("#formModbusCihazDataEkle input[name='fmbusfunction']");

    var selectSwapMode = $("#formModbusCihazDataEkle select[name='fswapmode']");
    var selectSwapModeSelectedItems = $(':selected', '#selectSwapMode');

    var inputRegisterAddress = $("#formModbusCihazDataEkle input[name='fregisteraddress']");
    var inputVarDefinition = $("#formModbusCihazDataEkle input[name='fvardef']");
    var inputVarMultiplier = $("#formModbusCihazDataEkle input[name='fvarmultiplier']");

    deviceRecordNo.val($(tableDeviceListSelectedRow).find('td#colRecordNo').html());

    testButton.attr('style', "display:block;width:50%;");
    submitButton.attr('style', "width:50%;");

    if (ekleDegistirSil > 0) {
      varType = $(tableDeviceDataSelectedRow).find('td#colRegVarType').html();
      selectVarTypeSelectedItems.removeAttr('selected');

      if (varType == "UINT16")
        selectVarType.val(0);
      else if (varType == "INT16")
        selectVarType.val(1);
      else if (varType == "UINT32")
        selectVarType.val(2);
      else if (varType == "INT32")
        selectVarType.val(3);
      else if (varType == "REAL")
        selectVarType.val(4);
      else if (varType == "STRING")
        selectVarType.val(5);
      else if (varType == "UINT64")
        selectVarType.val(6);
      else if (varType == "INT64")
        selectVarType.val(7);

      inputMBusFunction.val($(tableDeviceDataSelectedRow).find('td#colMBusFunction').html());

      swapMode = $(tableDeviceDataSelectedRow).find('td#colSwapMode').html();
      selectSwapModeSelectedItems.removeAttr('selected');
      if (swapMode == "N/A")
        selectSwapMode.val(0);
      else if (swapMode == "Byte and Word Swap")
        selectSwapMode.val(1);
      else if (swapMode == "Byte Swap")
        selectSwapMode.val(2);
      else if (swapMode == "Word Swap")
        selectSwapMode.val(3);
      else if (swapMode == "64 Bit Reverse")
        selectSwapMode.val(4);
		


      inputRegisterAddress.val($(tableDeviceDataSelectedRow).find('td#colRegAddress').html());
      inputVarDefinition.val($(tableDeviceDataSelectedRow).find('td#colDefinition').html());
      inputVarMultiplier.val($(tableDeviceDataSelectedRow).find('td#colMultiplier').html());


      recordNo.val($(tableDeviceDataSelectedRow).find('td#colRecordNo').html());

      if (ekleDegistirSil == 1) {
        submitButton.html("Uygula");
        recordActionType.val("1");

        submitButton.removeAttr('onclick');
        submitButton.attr('onClick', "postform('table_cihaz_data_ekle.php', 'form#formModbusCihazDataEkle', TableCihazDataDegistirResultCallback);");

        testButton.html("Register Okuma Testi");
        testButton.removeAttr('onclick');
        testButton.attr('onClick', "postform('test_variable.php', 'form#formModbusCihazDataEkle', TableCihazDataTestResultCallback);");

      } else {
        submitButton.html("Sil");
        recordActionType.val("2");

        submitButton.removeAttr('onclick');
        submitButton.attr('onClick', "postform('table_cihaz_data_ekle.php', 'form#formModbusCihazDataEkle', TableCihazDataSilResultCallback);");

        testButton.attr('style', "display:none;with:0;");
        submitButton.attr('style', "width:100%;");
      }
    } else {
      selectVarTypeSelectedItems.removeAttr('selected');
      selectVarType.val(0);

      inputMBusFunction.val("");

      swapMode = $(tableDeviceListSelectedRow).find('td#colSwapMode').html();
      if (swapMode == "N/A")
        selectSwapMode.val(0);
      else if (swapMode == "Byte and Word Swap")
        selectSwapMode.val(1);
      else if (swapMode == "Byte Swap")
        selectSwapMode.val(2);
      else if (swapMode == "Word Swap")
        selectSwapMode.val(3);
      else if (swapMode == "64 Bit Reverse")
        selectSwapMode.val(4);

      inputRegisterAddress.val("");
      inputVarDefinition.val("");
      inputVarMultiplier.val("1");

      submitButton.html("Ekle");
      recordActionType.val("0");
      recordNo.val("0");

      submitButton.removeAttr('onclick');
      submitButton.attr('onClick', "postform('table_cihaz_data_ekle.php', 'form#formModbusCihazDataEkle', TableCihazDataEkleResultCallback);");

      testButton.html("Register Okuma Testi");
      testButton.removeAttr('onclick');
      testButton.attr('onClick', "postform('test_variable.php', 'form#formModbusCihazDataEkle', TableCihazDataTestResultCallback);");

    }
    modalDeviceDataTableChange.style.display = "block";
  }

  function Restart() {
    HTTP_get("restart.php", "", 0, "content_restart");
  }

  function Stopprogram() {
    HTTP_get("stopprogram.php", "", 0, "content_stop_program");
  }

  function Startprogram() {
    HTTP_get("startprogram.php", "", 0, "content_start_program");
  }

  function Upload(file_name) {
    HTTP_get("download.php", "packetfile", file_name, "content_start_program");
  }
</script>

<body>

  <div class="wrapper">

    <div class="header">
      <h2>MPDL</h2>
    </div>

    <div class="left-side">
      <ul>
        <li>
          <a id="liIPConfig" href="#" onclick="SideBarClick('liIPConfig','div-ip-configuration')">Logger IP Ayarları</a>
        </li>
        <li>
          <a id="liMODBusConfig" href="#" onclick="SideBarClick('liMODBusConfig','div-modbus-configuration')">MODBUS RS485 Ayarları</a>
        </li>
        <li>
          <a id="liDeviceDefinition" href="#" onclick="SideBarClick('liDeviceDefinition','div-device-definition')">MODBUS Cihaz Tanımlama</a>
        </li>

        <li>
          <a id="liConfImport" href="#" onclick="SideBarClick('liConfImport','div-confimport')">Konfigürasyon Yükle</a>
        </li>

        <li>
          <a id="liConfExport" href="#" onclick="SideBarClick('liConfExport','div-confexport')">Konfigürasyon Yedekle</a>
        </li>

        <li>
          <a id="liStopProgram" href="#" onclick="SideBarClick('liStopProgram','div-stop-program')">Uygulamayı Durdur</a>
        </li>

        <li>
          <a id="liStartProgram" href="#" onclick="SideBarClick('liStartProgram','div-start-program')">Uygulamayı Başlat</a>
        </li>

        <li>
          <a id="liRestart" href="#" onclick="SideBarClick('liRestart','div-restart')">Logger Yeniden Başlat</a>
        </li>

        <li>
          <a id="liUserSettings" href="#" onclick="SideBarClick('liUserSettings','div-user-settings')">Kullanıcı Ayarları</a>
        </li>

        <?php
          if (isset($_SESSION['login_ok']) && ($_SESSION['login_ok'] == 2)) {
            echo "<li> <a id=\"liUploadPacket\" href=\"#\" onclick=\"SideBarClick('liUploadPacket','div-upload-packet')\">Paket Yükle</a> </li>";
            echo "<li> <a id=\"liDownloadFile\" href=\"#\" onclick=\"SideBarClick('liDownloadFile','div-download-file')\">Dosya İndir</a> </li>";
          }
        ?>

      </ul>
    </div>

    <div class="right-side">
      <div id="demo"></div>

      <div id="div-version">
        <h2>
          HW :<?php system('cat /kirac/version_hw.txt', $sonuc); ?>&nbsp
          Firmware:<?php system('/kirac/api/expantion_api 9', $sonuc); ?>&nbsp
          Sys:<?php system('cat /kirac/version_sys.txt', $sonuc); ?>&nbsp
          IMEI:<?php system('cat /tmp/imei', $sonuc); ?>&nbsp
          MAC:<?php system('cat /tmp/mac_address', $sonuc);?>
        </h2>
        İnternet bağlantı durumu:
        <?php
        $sonuc = shell_exec('/kirac/api/ios_api 18');
        if ($sonuc == 1) echo "LAN ile bağlandı";
        else {
          $sonuc = shell_exec('/kirac/api/ios_api 19');
          if ($sonuc == 1) echo "GPRS ile bağlandı";
          else  echo "Bağlantı yok";
        }
        ?>
        <br>
        <br>
        <?php $sonuc = shell_exec('uptime');
        echo "<pre>uptime:$sonuc</pre>"; ?>
        <br>
        <?php $sonuc = shell_exec('df -h');
        echo "<pre>$sonuc</pre>"; ?>
        <br>
        <?php $sonuc = shell_exec('free');
        echo "<pre>$sonuc</pre>"; ?>
        <br>
        <?php $sonuc = shell_exec('ls -l /kirac/db');
        echo "<pre>$sonuc</pre>"; ?>
      </div>

      <div id="div-ip-configuration">
        <form id="formIPAyarlari" action="javascript:void(0);">
          <div id="table_content_ip_ayarlari"></div>
        </form>
        <div class="btn-group" style="width:100%;">
          <button style="width:100%" onclick="postform('table_ip_ayarlari_set.php', 'form#formIPAyarlari', 0)">Kaydet</button>
        </div>
      </div>

      <div id="div-modbus-configuration">
        <form id="formRSAyarlari" action="javascript:void(0);">
          <div id="table_content_rs_ayarlari"></div>
        </form>
        <div class="btn-group" style="width:100%;">
          <button style="width:100%" onclick="postform('table_rs_ayarlari_set.php', 'form#formRSAyarlari', 0)">Kaydet</button>
        </div>
      </div>

      <div id="div-device-definition">
        <div class="port-config" style="background-color: white/*#95a5a6*/;">
          <h2>MODBUS Cihaz Listesi</h2>
          <div class="btn-group" style="width:100%;">
            <button style="width:25%" onclick="cihazEkle(0)">Yeni</button>
            <button style="width:25%" onclick="cihazEkle(1)">Düzenle</button>
            <button style="width:25%" onclick="cihazCopy()">Kopyala</button>
            <button style="width:25%" onclick="cihazEkle(2)">Sil</button>
          </div>
          <div id="table_content_cihaz_listesi"></div>
        </div>

        <div class="port-config" style="background-color: white /*#bdc3c7*/;">
          <h2>MODBUS Register Listesi</h2>
          <div class="btn-group" style="width:100%;">
            <button style="width:33.3%" onclick="cihazDataEkle(0)">Yeni</button>
            <button style="width:33.3%" onclick="cihazDataEkle(1)">Düzenle</button>
            <button style="width:33.3%" onclick="cihazDataEkle(2)">Sil</button>
          </div>
          <div id="table_content_cihaz_datasi"></div>
        </div>
      </div>


      <div id="div-upload-packet">
        <h2>Paket Yükle</h2>
        <form id="formUploadPacket" action="javascript:void(0);">
          <input style="width:100%" type="file" name="packetfile" id="packetfile" class="inputfile" onchange="postform_upload('upload_packet.php', '#formUploadPacket')"/>
          <label style="width:100%" for="packetfile">Güncelleme paketini seç (zkr_update_file.zip)</label>
        </form>
      </div>

      <div id="div-download-file">
        <form id="formDownloadFile" action="javascript:void(0);">
          <div class="row">
            <div class="col-25">
              <label for="ffilepath">Dosya Yolu</label>
            </div>
            <div class="col-75">
              <input id="inputFilePath" type="text" name="ffilepath" value="">
            </div>
          </div>
        </form>
        <div class="btn-group" style="width:100%;">
          <button style="width:100%" onclick="location.href='df.php?ffilepath='+document.getElementById('inputFilePath').value;">İndir</button>
        </div>
      </div>

      <div id="div-confimport">
        <h2>Konfigürasyon Yükle</h2>

        <form id="formUploadDBFile" action="javascript:void(0);">
          <input style="width:100%" type="file" name="dbfile" id="dbfile" class="inputfile" onchange="postform_upload('upload.php', '#formUploadDBFile')"/>
          <label style="width:100%" for="dbfile">Konfigürasyon dosyasını seç</label>
        </form>

      </div>

      <div id="div-confexport">
        <h2>Konfigürasyon Yedekle</h2>

        <div class="btn-group" style="width:100%;">
          <button style="width:100%" onclick="location.href='download.php?file=sungateway.db';">Yedekle</button>
        </div>

      </div>

      <div id="div-restart">
        <div class="port-config" style="background-color: white/*#95a5a6*/;">
          <h2>Yeniden Başlat</h2>
          <div class="btn-group" style="width:100%;">
            <button style="width:100%" onclick="Restart()">Yeniden Başlat</button>
          </div>
          <div id="content_restart"></div>
        </div>
      </div>

      <div id="div-stop-program">
        <div class="port-config" style="background-color: white/*#95a5a6*/;">
          <h2>Uygulamayı Durdur</h2>
          <div class="btn-group" style="width:100%;">
            <button style="width:100%" onclick="Stopprogram()">Uygulamayı Durdur</button>
          </div>
          <div id="content_stop_program"></div>
        </div>
      </div>

      <div id="div-start-program">
        <div class="port-config" style="background-color: white/*#95a5a6*/;">
          <h2>Uygulamayı Başlat</h2>
          <div class="btn-group" style="width:100%;">
            <button style="width:100%" onclick="Startprogram()">Uygulamayı Başlat</button>
          </div>
          <div id="content_start_program"></div>
        </div>
      </div>

      <div id="div-user-settings">
        <form id="formKullaniciAyarlari" action="javascript:void(0);">
          <div id="table_content_kullanici_ayarlari"></div>
        </form>
        <div class="btn-group" style="width:100%;">
          <button style="width:100%" onclick="postform('table_kullanici_ayarlari_set.php', 'form#formKullaniciAyarlari', TableKullaniciayarlariResultCallback)">Kaydet</button>
        </div>
      </div>

      <!-- The Modal Device List -->
      <div id="modalDeviceTableChange" class="modal">

        <!-- Modal content -->
        <div class="modal-content">
          <span class="close">&times;</span>
          <br>

          <form id="formModbusCihazEkle" action="javascript:void(0);">
            <fieldset>
              <legend>MODBUS Cihazı</legend>

              <input type="hidden" id="recordActionType" name="frecordactiontype" value="">
              <input type="hidden" id="recordNo" name="frecordno" value="">

              <div class="row">
                <div class="col-25">
                  <label for="fstationid">İstasyon ID</label>
                </div>
                <div class="col-75">
                  <input id="inputDeviceSatationID" type="text" name="fstationid" value="">
                </div>
              </div>

              <div class="row">
                <div class="col-25">
                  <label for="fcommtype">Haberleşme Tipi</label>
                </div>
                <div class="col-75">
                  <select id="selectCommType" name="fcommtype">
                    <option value="0">RS-485</option>
                    <option value="1">TCP/IP</option>
                    <option value="2">KACO Standard</option>
                    <option value="3">KACO Generic</option>
                  </select>
                </div>
              </div>

              <div class="row">
                <div class="col-25">
                  <label for="fdeviceid">Slave ID</label>
                </div>
                <div class="col-75">
                  <input id="inputDeviceID" type="text" name="fdeviceid" value="">
                </div>
              </div>

              <div class="row">
                <div class="col-25">
                  <label for="fdevicename">Device ID</label>
                </div>
                <div class="col-75">
                  <input id="inputDeviceName" type="text" name="fdevicename" value="">
                </div>
              </div>
			  

              <div class="row">
                <div class="col-25">
                  <label for="fswapmode">Swap Mode</label>
                </div>
                <div class="col-75">
                  <select id="selectSwapMode" name="fswapmode">
                    <option value="0">N/A</option>
                    <option value="1">Byte and Word Swap</option>
                    <option value="2">Byte Swap</option>
                    <option value="3">Word Swap</option>
                    <option value="4">64 Bit Reverse</option>
                  </select>
                </div>
              </div>

              <div class="row">
                <div class="col-25">
                  <label for="fdeviceip">TCP IP</label>
                </div>
                <div class="col-75">
                  <input id="inputDeviceIP" type="text" name="fdeviceip" value="">
                </div>
              </div>

              <div class="row">
                <div class="col-25">
                  <label for="ftcpport">TCP Port</label>
                </div>
                <div class="col-75">
                  <input id="inputTCPPort" type="text" name="ftcpport" value="">
                </div>
              </div>

              <div class="row">
                <div class="col-25">
                  <label for="fdevicedef">Cihaz Tanımı</label>
                </div>
                <div class="col-75">
                  <input id="inputDeviceDefinition" type="text" name="fdevicedef" value="">
                </div>
              </div>

              <div class="row">
                <div class="col-25">
                  <label for="factive">Aktif</label>
                </div>
                <div class="col-75">
                  <input id="inputActive" type="checkbox" name="factive" value="">
                </div>
              </div>

              <div class="btn-group" style="width:100%;margin-top: 5px;">
                <button style="width:100%"></button>
              </div>

            </fieldset>
          </form>

        </div>

      </div>

      <!-- The Modal Device Copy -->
      <div id="modalDeviceTableCopy" class="modal">

        <!-- Modal content -->
        <div class="modal-content">
          <span class="close">&times;</span>
          <br>

          <form id="formModbusCihazCopy" action="javascript:void(0);">
            <fieldset>
              <legend>MODBUS Cihaz Kopyala</legend>

              <input type="hidden" id="recordNo" name="frecordno" value="">

              <div class="row">
                <div class="col-25">
                  <label for="fstationid">İstasyon ID</label>
                </div>
                <div class="col-75">
                  <input id="inputDeviceSatationID" type="text" name="fstationid" value="">
                </div>
              </div>

              <div class="row">
                <div class="col-25">
                  <label for="fdeviceid">Slave ID</label>
                </div>
                <div class="col-75">
                  <input id="inputDeviceID" type="text" name="fdeviceid" value="">
                </div>
              </div>

              <div class="row">
                <div class="col-25">
                  <label for="fdevicename">Device ID</label>
                </div>
                <div class="col-75">
                  <input id="inputDeviceName" type="text" name="fdevicename" value="">
                </div>
              </div>

              <div class="btn-group" style="width:100%;margin-top: 5px;">
                <button style="width:100%"></button>
              </div>

            </fieldset>
          </form>
        </div>
      </div>

      <!-- The Modal Device Data -->
      <div id="modalDeviceDataTableChange" class="modal">

        <!-- Modal content -->
        <div class="modal-content">
          <span class="close">&times;</span>
          <br>

          <form id="formModbusCihazDataEkle" action="javascript:void(0);">
            <fieldset>
              <legend>MODBUS Register</legend>

              <input type="hidden" id="recordActionType" name="frecordactiontype" value="">
              <input type="hidden" id="recordNo" name="frecordno" value="">
              <input type="hidden" id="devicerecordNo" name="fdevicerecordno" value="">

              <div class="row">
                <div class="col-30">
                  <label for="fregisteraddress">Register Adresi</label>
                </div>
                <div class="col-70">
                  <input id="inputRegisterAddress" type="text" name="fregisteraddress" value="">
                </div>
              </div>

              <div class="row">
                <div class="col-30">
                  <label for="fmbusfunction">Modbus/Kaco Fonksiyonu</label>
                </div>
                <div class="col-70">
                  <input id="inputMBusFunction" type="text" name="fmbusfunction" value="">
                </div>
              </div>

              <div class="row">
                <div class="col-30">
                  <label for="fswapmode">Swap Mode</label>
                </div>
                <div class="col-70">
                  <select id="selectSwapMode" name="fswapmode">
                    <option value="0">N/A</option>
                    <option value="1">Byte and Word Swap</option>
                    <option value="2">Byte Swap</option>
                    <option value="3">Word Swap</option>
                    <option value="4">64 Bit Reverse</option>
                  </select>
                </div>
              </div>


              <div class="row">
                <div class="col-30">
                  <label for="fvartype">Register Tipi</label>
                </div>
                <div class="col-70">
                  <select id="selectVarType" name="fvartype">
                    <option value="0">UINT16</option>
                    <option value="1">INT16</option>
                    <option value="2">UINT32</option>
                    <option value="3">INT32</option>
                    <option value="4">REAL</option>
                    <option value="5">STRING</option>
                    <option value="6">UINT64</option>
                    <option value="7">INT64</option>
                  </select>
                </div>
              </div>

              <div class="row">
                <div class="col-30">
                  <label for="fvarmultiplier">Register Çarpanı</label>
                </div>
                <div class="col-70">
                  <input id="inputVarMultiplier" type="text" name="fvarmultiplier" value="">
                </div>
              </div>

              <div class="row">
                <div class="col-30">
                  <label for="fvardef">Register Tanımı</label>
                </div>
                <div class="col-70">
                  <input id="inputVarDefinition" type="text" name="fvardef" value="">
                </div>
              </div>

              <div class="btn-group" style="width:100%;margin-top: 5px;">
                <button style="width:50%" name="btnRecordAction"></button>
                <button style="width:50%" name="btnTest"></button>
              </div>

            </fieldset>
          </form>
        </div>

      </div>

    </div>

    <div class="footer">
      <p>
        Kıraç Bilgi ve İletişim Teknolojileri © 2018. Her hakkı saklıdır.
      </p>
    </div>

  </div>

  <script>
    var OldVisibleRightSideDiv = "div-version";
    var OldHighlightedSideMenuID = "";
    var responseOK = 1;
    var intervalHandle = 0;
    var timeoutHandle = 0;
    var tableDeviceListSelectedRow = 0;
    var tableDeviceDataSelectedRow = 0;

    var modalDeviceTableChange = document.getElementById('modalDeviceTableChange');
    var modalDeviceDataTableChange = document.getElementById('modalDeviceDataTableChange');
    var modalDeviceTableCopy = document.getElementById('modalDeviceTableCopy');

    var spanDeviceList = document.getElementsByClassName("close")[0];
    var spanDeviceCopy = document.getElementsByClassName("close")[1];
    var spanDeviceData = document.getElementsByClassName("close")[2];

    spanDeviceList.onclick = function() {
      modalDeviceTableChange.style.display = "none";
    };

    spanDeviceCopy.onclick = function() {
      modalDeviceTableCopy.style.display = "none";
    };

    spanDeviceData.onclick = function() {
      modalDeviceDataTableChange.style.display = "none";
    };

    window.onclick = function(event) {
      if (event.target == modalDeviceTableChange) {
        modalDeviceTableChange.style.display = "none";
      }

      if (event.target == modalDeviceTableCopy) {
        modalDeviceTableCopy.style.display = "none";
      }

      if (event.target == modalDeviceDataTableChange) {
        modalDeviceDataTableChange.style.display = "none";
      }
    };
  </script>




</body>

</html>
